# WzSLinker 网页炒股软件联动助手

<div align="center">

![WzSLinker Logo](icon.png)**高效精准识别A股代码和名称，联动本地股票软件**

[![Version](https://img.shields.io/badge/version-9.1.7-blue.svg)](https://github.com/your-repo/WzSLinker-JS)
[![Manifest](https://img.shields.io/badge/manifest-v3-green.svg)](manifest.json)
[![Chrome](https://img.shields.io/badge/Chrome-88+-brightgreen.svg)](https://www.google.com/chrome/)
[![License](https://img.shields.io/badge/license-MIT-orange.svg)](LICENSE)



---

## 📖 项目简介

WzSLinker 是一款专业的浏览器扩展，专为股票投资者和金融从业者设计。它能够智能识别网页中的 A 股股票代码和名称，提供高亮显示和本地股票软件联动功能，让您的投资研究效率大幅提升。

### ✨ 核心特性

- 🎯 **精准识别**：智能识别 A 股股票代码（6位数字）和股票名称
- 🎨 **多种高亮**：支持普通、发光、极简三种显示样式
- 🌈 **颜色自定义**：支持自定义高亮背景色和文字颜色
- 🔗 **本地联动**：一键联动本地股票软件（通达信、同花顺等）
- 💾 **数据管理**：支持 JSON 格式的股票数据导入导出
- 🎛️ **灵活配置**：丰富的个性化设置选项
- 📊 **实时统计**：显示当前高亮数量、股票数据量、联动记录
- 📝 **历史记录**：保存最近 100 条联动历史
- ⚠️ **错误提示**：页面内优雅显示服务连接错误提示
- 💖 **打赏支持**：精美的打赏界面，支持开发者持续优化

---

## 🚀 快速开始

### 安装方式

#### 开发者模式安装

1. 下载解压WzSLinker-JS.rar文件
2. 打开 浏览器（Chrome，edge），访问 `chrome://extensions/`
3. 开启右上角的"开发者模式"
4. 点击"加载已解压的扩展程序"
5. 选择项目文件夹 `WzSLinker-JS`

### 本地服务配置

WzSLinker 需要配合本地服务使用，实现与炒股软件的联动：

1. 访问官网 https://hrfocus.top 下载本地服务程序
2. 运行本地服务（默认端口 3000）
3. 在扩展设置中配置服务地址（默认 `http://localhost:3000`）
4. 测试连接确保服务正常运行

### 首次使用

1. **安装完成后**，扩展会自动加载默认股票数据库
2. **点击扩展图标**，打开主界面查看功能
3. **浏览任意网页**，股票代码和名称会自动高亮显示
4. **点击高亮的股票**，即可联动本地股票软件

---

## 🎯 功能详解

### 1. 股票识别

- **股票代码**：自动识别 6 位数字的 A 股代码
- **股票名称**：精确匹配股票中文名称
- **动态内容**：实时监测页面变化，自动识别新增内容
- **全页面支持**：支持所有网页类型（新闻、论坛、社交媒体等）

### 2. 高亮样式

| 样式 | 效果描述 | 适用场景 |
|------|---------|----------|
| **普通** | 黄色背景 + 红色加粗文字 | 日常浏览，清晰醒目 |
| **发光** | 半透明背景 + 金色发光边框 | 重点标注，专业美观 |
| **极简** | 透明背景 + 点状下划线 | 简洁模式，不干扰阅读 |

### 3. 联动功能

#### 工作原理

```
网页识别 → 点击股票 → 发送到本地服务 → 联动炒股软件 → 显示股票详情
```

#### 支持的软件

- 通达信
- 同花顺  
- 东方财富
- 大智慧
- 其他支持外部联动的股票软件

#### 联动记录

- 自动记录最近 100 条联动历史
- 支持查看和清空历史记录

### 4. 数据管理

#### 导入数据

支持 JSON 格式批量导入股票数据：

```json
{
  "贵州茅台": "600519",
  "五粮液": "000858",
  "宁德时代": "300750"
}
```

#### 导出数据

一键导出当前股票数据库为 JSON 文件，方便备份和分享。

#### 手动管理

- 添加单个股票：输入股票名称和代码
- 删除股票：从数据库中移除指定股票
- 清空数据：重置整个股票数据库

### 5. 个性化设置

#### 基础设置

- **高亮开关**：一键开启/关闭高亮功能
- **高亮样式**：选择普通/发光/极简三种样式
- **高亮颜色**：自定义高亮背景颜色
- **文字颜色**：自定义高亮文字颜色

#### 高级设置

- **本地服务地址**：配置联动服务 URL
- **测试连接**：验证服务连通性
- **重置设置**：恢复默认配置

---

## 📁 项目结构

```
WzSLinker-JS/
├── manifest.json              # 扩展清单文件（Manifest V3）
├── background.js              # 后台服务脚本
├── content-script.js          # 内容脚本（核心识别逻辑）
├── utils.js                   # 公共工具函数
├── popup.html                 # 弹出窗口界面
├── popup.css                  # 弹出窗口样式
├── popup.js                   # 弹出窗口逻辑
├── options.html               # 设置页面
├── options.css                # 设置页面样式
├── options.js                 # 设置页面逻辑
├── common.css                 # 通用样式
├── highlight.css              # 高亮样式
├── _locales/                  # 国际化文件
│   └── zh_CN/
│       └── messages.json      # 中文语言包
├── stock-data.json            # 默认股票数据
├── icon.png                   # 扩展图标
├── close16_2x.png             # 关闭状态图标
├── wechat_img.png             # 微信打赏二维码
└── README.md                  # 项目说明
```

### 设计理念

- **科技感**：采用黑色、灰色、红色、蓝色配色方案
- **专业感**：符合金融行业审美标准
- **简约风**：突出功能性，减少视觉干扰
- **现代化**：流畅的动画效果和微交互

### 弹窗界面（Popup）

- 扩展状态显示（开启/关闭）
- 快速切换高亮开关
- 实时统计信息
- 联动历史记录
- 打赏支持入口

### 设置页面（Options）

- 高亮样式设置
- 颜色自定义
- 数据管理（导入/导出/添加/清空）
- 本地服务配置
- 样式预览

### 页内弹窗

- 居中显示，半透明遮罩
- 渐变背景，动画效果
- 错误信息清晰易懂
- 一键跳转官网下载

---

## 📊 使用场景

### 1. 财经新闻浏览
在东方财富、新浪财经等网站浏览新闻时，自动高亮文章中提到的股票，点击即可查看详情。

### 2. 投资论坛交流
在雪球、淘股吧等论坛讨论股票时，快速识别提到的股票代码和名称。

### 3. 社交媒体发现
在微博、知乎等社交平台上，发现投资机会时快速联动查看。

### 4. 研究报告阅读
阅读券商研究报告、行业分析时，快速定位和查看股票信息。

### 5. 股市直播间
观看股市直播时，实时联动主播提到的股票。

---

## 🔒 隐私保护

### 数据存储

- 所有数据仅存储在**本地浏览器**中
- 使用 Chrome Storage API，数据加密存储
- 不上传任何数据到云端服务器

### 权限说明

| 权限 | 用途 | 必要性 |
|------|------|--------|
| storage | 存储股票数据和用户设置 | 必需 |
| activeTab | 识别当前页面的股票信息 | 必需 |
| tabs | 管理标签页高亮状态 | 必需 |
| notifications | 显示操作结果通知 | 可选 |
| scripting | 注入内容识别脚本 | 必需 |
| localhost:3000 | 连接本地服务实现联动 | 可选 |

### 隐私承诺

✅ 不收集个人信息  
✅ 不追踪浏览行为  
✅ 不上传用户数据  
✅ 不嵌入广告追踪  
✅ 开源透明，代码可审计  

---

## 💖 支持项目

如果这个扩展对您有帮助，欢迎通过以下方式支持：

- ⭐ **给项目点星**：在 GitHub 上给项目点 Star
- 📢 **分享推荐**：向朋友推荐这个扩展
- 🐛 **反馈问题**：及时反馈使用中遇到的问题

---

---

## 💖 联系与赞助


![img](file:///C:/Users/Bruce/Desktop/Wzslinker-网页联动炒股软件/WzSLinker-扩展程序/WzSLinker-JS/添加微信截图.jpg)![img](file:///C:/Users/Bruce/Desktop/Wzslinker-网页联动炒股软件/WzSLinker-扩展程序/WzSLinker-JS/微信打赏截图.jpg)

- **作者**: 祝先生Bruce
- **技术支持 & 商务合作微信**: `370589873` (添加时请备注：WzSLinker)      
- Made with ❤️ for Chinese Stock Market Investors

